/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWCaseTypeSelectionDialog;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.CEObjectInfoCache;
import filenet.vw.base.SdfFileInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.swing.JOptionPane;

public class VWSolutionHelper {
    private static final String QUEUE_CE_OPERATIONS = "CE_Operations";
    private static final String DEFAULT_LAUNCH_STEP_NAME = "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE";
    private VWDesignerCoreData m_designerCoreData = null;
    private IVWIDMDocument m_idmSdfDoc = null;
    private IVWIDMDocument m_idmPEConfig = null;
    private IVWIDMDocument m_idmXPDLDoc = null;
    private IVWIDMDocument m_idmGlobalXPDLDoc = null;
    private SdfFileInfo m_sdfFileInfo = null;
    private CEObjectInfo m_xpdlFileInfo = null;
    private CEObjectInfoCache m_ceObjectInfoCache = null;
    private boolean m_bOpenedFromSolutionsPage = false;
    private boolean m_bOpenedFromCaseTaskPage = false;
    private boolean m_bContainsMultipleCaseTypes = false;

    protected VWSolutionHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public String getSdfFileContents() {
        return this.m_sdfFileInfo.toString();
    }

    public String getDefaultLaunchStepProcessorName() {
        String prefix = this.m_sdfFileInfo.getSolutionPrefix();
        if (prefix != null && prefix.length() > 0) {
            return prefix + DEFAULT_LAUNCH_STEP_NAME;
        }
        return null;
    }

    protected CEObjectInfoCache getCEObjectInfoCache(VWDataDictionary dataDictionary) throws VWException {
        return this.m_ceObjectInfoCache;
    }

    protected boolean isSolutionOpenedFromCaseBuilder() {
        return this.m_bOpenedFromSolutionsPage || this.m_bOpenedFromCaseTaskPage;
    }

    protected boolean isSolutionOpenedFromCaseTaskPage() {
        return this.m_bOpenedFromCaseTaskPage;
    }

    protected boolean isSolutionContainsMultipleCaseTypes() {
        return this.m_bContainsMultipleCaseTypes;
    }

    protected String getSolutionName() {
        String displayName = null;
        if (this.m_sdfFileInfo != null) {
            displayName = this.m_sdfFileInfo.getSolutionName();
        }
        if (this.m_xpdlFileInfo != null) {
            displayName = displayName + ": " + this.m_xpdlFileInfo.toString();
        }
        return displayName;
    }

    protected boolean performEditSolutionAction(String osName, String sdfVsId, String caseTypeSymbolicName, String workflowName) throws Exception {
        try {
            int confirmResult;
            IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
            if (idmFactory != null) {
                if (osName != null && sdfVsId != null) {
                    this.m_idmSdfDoc = idmFactory.getIDMDocument(osName, sdfVsId, null);
                    this.m_bOpenedFromSolutionsPage = true;
                } else {
                    String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_open_withHK);
                    IVWIDMItem contextItem = this.m_designerCoreData.getFileContext().getIDMContextItem();
                    IVWIDMDialog dialog = idmFactory.getBrowseDialog(contextItem, 1, resources[0], null);
                    dialog.setTitle(VWResource.s_openSolutionTitle);
                    dialog.setButtonMnemonic(resources[1]);
                    dialog.setButtonTooltip(VWResource.s_select);
                    if (dialog.showDialog(this.m_designerCoreData.getParentFrame()) != 0) {
                        return false;
                    }
                    this.m_idmSdfDoc = (IVWIDMDocument)dialog.getSelectedItem();
                }
            }
            if (this.m_idmSdfDoc == null) {
                return false;
            }
            this.m_designerCoreData.getFileContext().setIDMContextItem(this.m_idmSdfDoc);
            boolean bCheckItOut = false;
            bCheckItOut = this.m_idmSdfDoc.isExclusiveLockOwner() ? true : (this.m_idmSdfDoc.canCheckin() ? (confirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_assumeCheckOut, VWResource.s_fnOpenTitle, 0)) == 0 : this.m_idmSdfDoc.canCheckout());
            if (!bCheckItOut) {
                return false;
            }
            CEObjectInfo globalXpdlFileInfo = null;
            try {
                byte[] fileContents = this.m_idmSdfDoc.getContents(true);
                if (fileContents == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.EmptySdfFile", "The file appears to be empty.");
                }
                this.m_ceObjectInfoCache = new CEObjectInfoCache(this.m_designerCoreData.getSessionInfo().getSession(), this.m_designerCoreData.getDataDictionary().getSystemConfiguration(), new String(fileContents, "UTF8"));
                this.m_sdfFileInfo = this.m_ceObjectInfoCache.getSdfFileInfo();
                CEObjectInfo[] ceObjInfos = this.m_sdfFileInfo.getCaseObjects();
                int nCaseTypeCount = 0;
                if (ceObjInfos != null) {
                    nCaseTypeCount = ceObjInfos.length;
                }
                globalXpdlFileInfo = this.m_sdfFileInfo.getGlobalProcessCollectionObjectInfo();
                if (nCaseTypeCount == 0 && globalXpdlFileInfo == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NoCaseTypesFound", "The Solution does not contain any Case Types.");
                }
                boolean bl = this.m_bContainsMultipleCaseTypes = nCaseTypeCount > 1 || nCaseTypeCount == 1 && globalXpdlFileInfo != null;
                if (caseTypeSymbolicName != null && caseTypeSymbolicName.length() > 0) {
                    if (ceObjInfos != null) {
                        for (int i = 0; i < ceObjInfos.length; ++i) {
                            if (!caseTypeSymbolicName.equals(ceObjInfos[i].getSymbolicName())) continue;
                            this.m_xpdlFileInfo = ceObjInfos[i];
                            break;
                        }
                    }
                    if (this.m_xpdlFileInfo == null) {
                        throw new VWException("vw.apps.designer.VWSolutionHelper.CaseTypeNotFound", "The Solution does not contain the specified Case Type \"{0}\".", caseTypeSymbolicName);
                    }
                    this.m_bOpenedFromSolutionsPage = false;
                    this.m_bOpenedFromCaseTaskPage = true;
                } else if (this.m_bContainsMultipleCaseTypes) {
                    if (!this.performSelectCaseTypeAction(false, workflowName)) {
                        this.performCloseAction(false);
                        return false;
                    }
                } else {
                    this.m_xpdlFileInfo = ceObjInfos == null || nCaseTypeCount == 0 ? globalXpdlFileInfo : ceObjInfos[0];
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                throw new VWException("vw.apps.designer.VWSolutionHelper.CannotEditSolution", "The solution could not be edited. {0}", ex.getLocalizedMessage());
            }
            VWAttachment sdfAttachment = this.m_idmSdfDoc.getVWAttachment();
            this.checkOutAndOpenPEConfig(sdfAttachment, this.m_sdfFileInfo.getProcessConfigGuid());
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 756, null);
            this.openSelectedCaseTypeXPDL(sdfAttachment, globalXpdlFileInfo, workflowName);
        }
        catch (Exception ex) {
            this.performCloseAction(false);
            throw ex;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performSelectCaseTypeAction(boolean bLoadOnSelection, String workflowName) {
        block26: {
            block27: {
                block25: {
                    outStream = null;
                    try {
                        try {
                            nConfirmResult = -1;
                            if (this.m_xpdlFileInfo != null && (nConfirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_saveChangesQuestion)) == 2) {
                                var5_6 = false;
                                var9_8 = null;
                                if (outStream == null) return var5_6;
                                break block25;
                            }
                            selectionDlg = new VWCaseTypeSelectionDialog(this.m_designerCoreData, this.m_sdfFileInfo);
                            if (selectionDlg == null) break block26;
                            selectionDlg.setVisible(true);
                            if (selectionDlg.getExitStatus() != 0) break block26;
                            if (this.m_xpdlFileInfo != null) {
                                switch (nConfirmResult) {
                                    case 0: {
                                        if (this.m_idmXPDLDoc != null && this.m_idmXPDLDoc.isCheckedOut() && this.m_idmXPDLDoc.canCheckin() && (workflowCollectionDefinition = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition()) != null) {
                                            outStream = new ByteArrayOutputStream();
                                            workflowCollectionDefinition.write(outStream);
                                            fileContents = outStream.toByteArray();
                                            if (this.m_bOpenedFromCaseTaskPage) {
                                                this.m_idmXPDLDoc.saveContents(fileContents, this.m_idmXPDLDoc.getFileName());
                                            } else {
                                                this.m_idmXPDLDoc.checkin(this.m_designerCoreData.getParentFrame(), fileContents, false, this.m_idmXPDLDoc.getFileName(), "");
                                            }
                                        }
                                        this.m_idmXPDLDoc = null;
                                        break;
                                    }
                                    case 1: {
                                        if (this.m_idmXPDLDoc != null && this.m_idmXPDLDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                                            this.m_idmXPDLDoc.cancelCheckoutNoUI();
                                        }
                                        this.m_idmXPDLDoc = null;
                                        break;
                                    }
                                }
                            }
                            if (this.m_idmGlobalXPDLDoc != null) {
                                if (this.m_idmGlobalXPDLDoc != null && this.m_idmGlobalXPDLDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                                    this.m_idmGlobalXPDLDoc.cancelCheckoutNoUI();
                                }
                                this.m_idmGlobalXPDLDoc = null;
                            }
                            this.m_xpdlFileInfo = selectionDlg.getSelectedCEObject();
                            if (bLoadOnSelection) {
                                globalXpdlFileInfo = this.m_sdfFileInfo.getGlobalProcessCollectionObjectInfo();
                                sdfAttachment = this.m_idmSdfDoc.getVWAttachment();
                                this.openSelectedCaseTypeXPDL(sdfAttachment, globalXpdlFileInfo, workflowName);
                            }
                            var6_19 = true;
                            break block27;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            var9_11 = null;
                            if (outStream == null) return false;
                            try {
                                outStream.close();
                                return false;
                            }
                            catch (Throwable ignore) {
                                return false;
                            }
                        }
                    }
                    catch (Throwable var8_21) {
                        var9_12 = null;
                        if (outStream == null) throw var8_21;
                        ** try [egrp 2[TRYBLOCK] [7 : 420->427)] { 
lbl61:
                        // 1 sources

                        outStream.close();
                        throw var8_21;
lbl63:
                        // 1 sources

                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        throw var8_21;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [7 : 420->427)] { 
lbl68:
                // 1 sources

                outStream.close();
                return var5_6;
lbl70:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
                return var5_6;
            }
            var9_9 = null;
            if (outStream == null) return var6_19;
            try {}
            catch (Throwable ignore) {
                // empty catch block
                return var6_19;
            }
            outStream.close();
            return var6_19;
        }
        var9_10 = null;
        if (outStream == null) return false;
        try {}
        catch (Throwable ignore) {}
        outStream.close();
        return false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSaveAction() {
        ByteArrayOutputStream outStream;
        block9: {
            VWSystemConfiguration sysConfig;
            byte[] fileContents;
            VWWorkflowCollectionDefinition workflowCollectionDefinition;
            outStream = null;
            if (this.m_idmXPDLDoc != null && this.m_idmXPDLDoc.isCheckedOut() && this.m_idmXPDLDoc.canCheckin() && (workflowCollectionDefinition = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition()) != null) {
                outStream = new ByteArrayOutputStream();
                workflowCollectionDefinition.write(outStream);
                fileContents = outStream.toByteArray();
                this.m_idmXPDLDoc.saveContents(fileContents, this.m_idmXPDLDoc.getFileName());
            }
            if (this.m_idmPEConfig == null || !this.m_idmPEConfig.isCheckedOut() || !this.m_idmPEConfig.canCheckin() || (sysConfig = this.m_designerCoreData.getDataDictionary().getSystemConfiguration()) == null) break block9;
            outStream = new ByteArrayOutputStream();
            sysConfig.exportConfigChanges(outStream);
            fileContents = outStream.toByteArray();
            this.m_idmPEConfig.saveContents(fileContents, this.m_idmPEConfig.getFileName());
        }
        Object var5_5 = null;
        if (outStream == null) return;
        try {
            outStream.close();
            return;
        }
        catch (Throwable ignore) {}
        return;
        {
            catch (Throwable t) {
                t.printStackTrace();
                Object var5_6 = null;
                if (outStream == null) return;
                try {
                    outStream.close();
                    return;
                }
                catch (Throwable ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (outStream == null) throw throwable;
            try {
                outStream.close();
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean performSaveAndCloseAction() {
        byte[] fileContents;
        ByteArrayOutputStream outStream = null;
        if (this.m_idmSdfDoc != null && this.m_idmSdfDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
            this.m_idmSdfDoc.cancelCheckoutNoUI();
        }
        this.m_idmSdfDoc = null;
        if (this.m_idmXPDLDoc != null && this.m_idmXPDLDoc.isCheckedOut() && this.m_idmXPDLDoc.canCheckin()) {
            VWWorkflowCollectionDefinition workflowCollectionDefinition = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition();
            if (workflowCollectionDefinition != null) {
                outStream = new ByteArrayOutputStream();
                workflowCollectionDefinition.write(outStream);
                fileContents = outStream.toByteArray();
                if (this.m_bOpenedFromCaseTaskPage) {
                    this.m_idmXPDLDoc.saveContents(fileContents, this.m_idmXPDLDoc.getFileName());
                } else {
                    this.m_idmXPDLDoc.checkin(this.m_designerCoreData.getParentFrame(), fileContents, false, this.m_idmXPDLDoc.getFileName(), "");
                }
            }
            this.m_idmXPDLDoc = null;
        }
        if (this.m_idmPEConfig != null && this.m_idmPEConfig.isCheckedOut() && this.m_idmPEConfig.canCheckin()) {
            VWSystemConfiguration sysConfig = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
            if (sysConfig != null) {
                outStream = new ByteArrayOutputStream();
                sysConfig.exportConfigChanges(outStream);
                fileContents = outStream.toByteArray();
                if (this.m_bOpenedFromCaseTaskPage) {
                    this.m_idmPEConfig.saveContents(fileContents, this.m_idmPEConfig.getFileName());
                } else {
                    this.m_idmPEConfig.checkin(this.m_designerCoreData.getParentFrame(), fileContents, false, this.m_idmPEConfig.getFileName(), "");
                }
            }
            this.m_idmPEConfig = null;
        }
        if (this.m_idmGlobalXPDLDoc != null && this.m_idmGlobalXPDLDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
            this.m_idmGlobalXPDLDoc.cancelCheckoutNoUI();
        }
        this.m_idmGlobalXPDLDoc = null;
        this.m_designerCoreData.resetDocumentHelpers();
        Object var5_6 = null;
        if (outStream == null) return true;
        try {
            outStream.close();
            return true;
        }
        catch (Throwable ignore) {}
        return true;
        {
            catch (Throwable t) {
                t.printStackTrace();
                boolean bl = false;
                Object var5_7 = null;
                if (outStream == null) return bl;
                try {
                    outStream.close();
                    return bl;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (outStream == null) throw throwable;
            try {
                outStream.close();
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean performCloseAction(boolean bPrompt) {
        try {
            if (bPrompt) {
                int nConfirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_saveChangesQuestion);
                switch (nConfirmResult) {
                    case 0: {
                        return this.performSaveAndCloseAction();
                    }
                    case 2: {
                        return false;
                    }
                }
            }
            if (this.m_idmSdfDoc != null && this.m_idmSdfDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                this.m_idmSdfDoc.cancelCheckoutNoUI();
            }
            this.m_idmSdfDoc = null;
            if (this.m_idmPEConfig != null && this.m_idmPEConfig.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                this.m_idmPEConfig.cancelCheckoutNoUI();
            }
            this.m_idmPEConfig = null;
            if (this.m_idmXPDLDoc != null && this.m_idmXPDLDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                this.m_idmXPDLDoc.cancelCheckoutNoUI();
            }
            this.m_idmXPDLDoc = null;
            if (this.m_idmGlobalXPDLDoc != null && this.m_idmGlobalXPDLDoc.isCheckedOut() && !this.m_bOpenedFromCaseTaskPage) {
                this.m_idmGlobalXPDLDoc.cancelCheckoutNoUI();
            }
            this.m_idmGlobalXPDLDoc = null;
            this.m_designerCoreData.resetDocumentHelpers();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkOutAndOpenPEConfig(VWAttachment sdfAttachment, String docId) throws Exception {
        ByteArrayInputStream inStream = null;
        try {
            try {
                VWQueueDefinition queueDef;
                byte[] fileContents;
                IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                if (idmFactory == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullIDMFactory", "The IDMFactory instance could not be found.");
                }
                this.m_idmPEConfig = idmFactory.getIDMDocument(sdfAttachment.getLibraryName(), docId, null);
                if (this.m_idmPEConfig == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullPEConfig", "The Process Engine Configuration file could not be found.");
                }
                if (!this.m_idmPEConfig.isExclusiveLockOwner() && !this.m_idmPEConfig.canCheckin()) {
                    if (!this.m_idmPEConfig.canCheckout()) throw new VWException("vw.apps.designer.VWSolutionHelper.CannotCheckoutPEConfig", "The current user is not the exclusive lock owner. Ensure the user has the necessary permissions to check out the file.");
                }
                if ((fileContents = this.m_idmPEConfig.getContents(true)) == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.EmptyPEConfigFile", "The file appears to be empty.");
                }
                VWSystemConfiguration originalSysConfig = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
                VWSystemConfiguration solutionConfig = this.m_designerCoreData.getDataDictionary().refetchSystemConfiguration(false);
                inStream = new ByteArrayInputStream(fileContents);
                solutionConfig.importConfig(inStream);
                inStream.close();
                if (originalSysConfig != null && (queueDef = originalSysConfig.getQueueDefinition(QUEUE_CE_OPERATIONS)) != null) {
                    if (solutionConfig.getQueueDefinition(QUEUE_CE_OPERATIONS) == null) {
                        solutionConfig.createQueueDefinition(QUEUE_CE_OPERATIONS, 1);
                    }
                    solutionConfig.updateQueueDefinition(queueDef);
                    VWClassFactory.VWQueueDefinition_setHasChanged(queueDef, true, 234L);
                }
                Object var10_10 = null;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                throw new VWException("vw.apps.designer.VWSolutionHelper.CannotOpenPEConfigFile", "The Process Engine Configuration file could not be checked out. {0}", ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (inStream == null) throw throwable;
                inStream.close();
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable ignore) {}
        if (inStream == null) return true;
        inStream.close();
        return true;
    }

    private void openSelectedCaseTypeXPDL(VWAttachment sdfAttachment, CEObjectInfo globalXpdlFileInfo, String workflowName) throws Exception {
        VWWorkflowCollectionDefinition globalWflCollDef;
        VWWorkflowCollectionDefinition workflowCollectionDefinition = this.checkOutAndOpenCaseTypeXPDL(sdfAttachment, this.m_xpdlFileInfo.getXpdlGuid());
        if (globalXpdlFileInfo != null && this.m_xpdlFileInfo != globalXpdlFileInfo && (globalWflCollDef = this.checkOutAndOpenGlobalXpdl(sdfAttachment, globalXpdlFileInfo.getXpdlGuid())) != null) {
            workflowCollectionDefinition.registerExternalWorkflowsFromCollection(globalWflCollDef);
        }
        VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 700, workflowCollectionDefinition);
        this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
        VWWorkflowDefinition mainWflDef = null;
        mainWflDef = this.m_bOpenedFromCaseTaskPage ? workflowCollectionDefinition.getWorkflow(workflowName) : workflowCollectionDefinition.getMainWorkflow();
        if (mainWflDef != null) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 716, mainWflDef);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VWWorkflowCollectionDefinition checkOutAndOpenCaseTypeXPDL(VWAttachment sdfAttachment, String docId) throws Exception {
        VWWorkflowCollectionDefinition workflowCollectionDefinition = null;
        ByteArrayInputStream inStream = null;
        try {
            try {
                byte[] fileContents;
                IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                if (idmFactory == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullIDMFactory", "The IDMFactory instance could not be found.");
                }
                if (docId == null) throw new VWException("vw.apps.designer.VWSolutionHelper.NullXPDLFile", "The XPDL file has not been created.");
                if (docId.trim().length() == 0) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullXPDLFile", "The XPDL file has not been created.");
                }
                this.m_idmXPDLDoc = idmFactory.getIDMDocument(sdfAttachment.getLibraryName(), docId, null);
                if (!this.m_idmXPDLDoc.isExclusiveLockOwner() && !this.m_idmXPDLDoc.canCheckin()) {
                    if (!this.m_idmXPDLDoc.canCheckout()) throw new VWException("vw.apps.designer.VWSolutionHelper.CannotCheckoutXPDL", "The current user is not the exclusive lock owner. Ensure the user has the necessary permissions to check out the file.");
                }
                if ((fileContents = this.m_idmXPDLDoc.getContents(true)) == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.EmptyXPDLFile", "The file appears to be empty.");
                }
                inStream = new ByteArrayInputStream(fileContents);
                workflowCollectionDefinition = VWWorkflowCollectionDefinition.read(inStream);
                if (workflowCollectionDefinition == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NotAValidXPDLFile", "The XPDL file is not valid.");
                }
                this.setSelectedApplicationSpaceDefinition(workflowCollectionDefinition);
                Object var8_8 = null;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                throw new VWException("vw.apps.designer.VWSolutionHelper.CannotOpenXPDL", "The XPDL file for the Workflow Collection Definition could not be checked out. {0}", ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (inStream == null) throw throwable;
                inStream.close();
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable ignore) {}
        if (inStream == null) return workflowCollectionDefinition;
        inStream.close();
        return workflowCollectionDefinition;
    }

    private void setSelectedApplicationSpaceDefinition(VWWorkflowCollectionDefinition workflowCollectionDefinition) {
        VWApplicationSpaceDefinition appSpaceDef = null;
        String appSpaceName = this.m_sdfFileInfo.getSolutionName();
        if (appSpaceName != null && appSpaceName.length() > 0 && (appSpaceDef = this.m_designerCoreData.getDataDictionary().getApplicationSpace(appSpaceName)) != null) {
            workflowCollectionDefinition.setApplicationSpaceName(appSpaceDef.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VWWorkflowCollectionDefinition checkOutAndOpenGlobalXpdl(VWAttachment sdfAttachment, String docId) throws Exception {
        VWWorkflowCollectionDefinition workflowCollectionDefinition = null;
        ByteArrayInputStream inStream = null;
        try {
            try {
                byte[] fileContents;
                IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                if (idmFactory == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullIDMFactory", "The IDMFactory instance could not be found.");
                }
                if (docId == null) throw new VWException("vw.apps.designer.VWSolutionHelper.NullSharedXPDLFile", "The shared XPDL file has not been created.");
                if (docId.trim().length() == 0) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NullSharedXPDLFile", "The shared XPDL file has not been created.");
                }
                this.m_idmGlobalXPDLDoc = idmFactory.getIDMDocument(sdfAttachment.getLibraryName(), docId, null);
                if (!this.m_idmGlobalXPDLDoc.isExclusiveLockOwner() && !this.m_idmGlobalXPDLDoc.canCheckin()) {
                    if (!this.m_idmGlobalXPDLDoc.canCheckout()) throw new VWException("vw.apps.designer.VWSolutionHelper.CannotCheckoutXPDL", "The current user is not the exclusive lock owner. Ensure the user has the necessary permissions to check out the file.");
                }
                if ((fileContents = this.m_idmGlobalXPDLDoc.getContents(true)) == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.EmptySharedXPDLFile", "The shared XPDL file appears to be empty.");
                }
                inStream = new ByteArrayInputStream(fileContents);
                workflowCollectionDefinition = VWWorkflowCollectionDefinition.read(inStream);
                if (workflowCollectionDefinition == null) {
                    throw new VWException("vw.apps.designer.VWSolutionHelper.NotAValidSharedXPDLFile", "The shared XPDL file is not valid.");
                }
                Object var8_8 = null;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                throw new VWException("vw.apps.designer.VWSolutionHelper.CannotOpenSharedXPDL", "The shared XPDL file could not be read. {0}", ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (inStream == null) throw throwable;
                inStream.close();
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable ignore) {}
        if (inStream == null) return workflowCollectionDefinition;
        inStream.close();
        return workflowCollectionDefinition;
    }
}

